//AIM: Implement Impulse Invariant method

//Find out H(z) using impulse invariances method at 5Hz sampling frequency
//from H(s) where H(s)=1/(s+1)(s+2)

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
s=%s;
s2=-2;
s1=-1;
d1=(s-s1);
p2=(s-s2);
if (s1) then   // When pole=-1
    s1=-1;
    s2=-2;
    s=s1;
    d2=(s-s2);
    num1=1/d2;  // Value of A1
h1=syslin('c', num1/d1)
end
disp(h1)
disp(num1,'value of A1=')
if (s2) then   // When pole=-2
    s1=-1;
    s2=-2;
    s=s2;
    p1=(s-s1);
    num2=1/p1;  // Value of A2
h2=syslin('c', num2/p2)
end
disp(h2)
disp(num2,'Value of A2=')
Hs=(h1)+(h2);
disp(Hs,'Transfer function of analog filter H(s)=')
//Obtain the Z-transform using impulse invariance transformation equation
//1/(s-pk)=1/[1-exp(pk*Ts)*Z^(-1)]
Fs=5;
Ts=1/Fs;
disp('sec',Ts,'Sampling time Ts=')
//we have poles at s1=-1 and s2=-2
Z=poly(0,"Z")
//1/(s+1)=a;We consider
a=num1/(1-exp(s1*(Ts))*Z^(-1));
//1/(s+2)=b;We consider
b=num2/(1-exp(s2*(Ts))*Z^(-1));
disp(a,'1/s+1=')
disp(b,'1/s+2=')
//The Transfer function of digital filter is given by,
//H(Z)=∑_(k=1)^N(Ak/(1-e^(pk*Ts)*Z^(-1) )
//H(Z)=A1/1-exp(p1*Ts)*Z^(-1)+A2/1-exp(p1*Ts)*Z^(-1)
Hz=(a+b);
disp(Hz,'The required transfer function for digital IIR filter H(Z)=')




